/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWException;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWCapsuleAES;
import filenet.vw.base.logging.Logger;
import org.w3c.dom.Element;

public class VWWSRRRegistry {
    public static final String XML_TAG_WSRR_REGISTRY = "WSRRRegistry";
    public static final String WSRR_TAG = "WSRRRegistry";
    public static final String XML_ATTRIBUTE_SERVER_NAME = "servername";
    public static final String XML_ATTRIBUTE_PORT = "port";
    public static final String XML_ATTRIBUTE_USER_INFO = "userinfo";
    public static final String XML_ATTRIBUTE_PUBLISH = "publish";
    private static Logger m_logger = Logger.getLogger("filenet.vw.base");
    private static final String m_className = "VWWSRRRegistry";
    protected String m_sServerName = null;
    protected String m_sPort = "";
    protected String m_sUserName = "";
    protected String m_sPassword = "";
    protected boolean m_bPublish = false;
    private VWCapsuleAES m_encryptUtils = null;

    public static String _get_FILE_DATE() {
        return "$Date:   08 Jan 2009 14:04:06  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    public VWWSRRRegistry() {
        this.m_encryptUtils = new VWCapsuleAES();
    }

    public VWWSRRRegistry(String s_serverName, String s_port, String s_encryptedUserInfo, boolean bPublish) throws Exception {
        try {
            this.m_encryptUtils = new VWCapsuleAES();
            this.m_sServerName = s_serverName.trim();
            this.m_sPort = s_port.trim();
            this.m_bPublish = bPublish;
            this.decryptUsernamePassword(s_encryptedUserInfo);
        }
        catch (Exception ex) {
            m_logger.error(m_className, "ctor", ex);
        }
    }

    public VWWSRRRegistry(Element WSRRRegistryEle) throws Exception {
        try {
            this.m_encryptUtils = new VWCapsuleAES();
            if (WSRRRegistryEle == null) {
                throw new VWException("vw.base.VWWSRRRegistry.constructor.DOM", "Element is null.");
            }
            this.m_sServerName = WSRRRegistryEle.getAttribute(XML_ATTRIBUTE_SERVER_NAME);
            this.m_sPort = WSRRRegistryEle.getAttribute(XML_ATTRIBUTE_PORT);
            String s_encryptedUserInfo = WSRRRegistryEle.getAttribute(XML_ATTRIBUTE_USER_INFO);
            String sPublish = WSRRRegistryEle.getAttribute(XML_ATTRIBUTE_PUBLISH);
            if (sPublish.compareTo("1") == 0) {
                this.m_bPublish = true;
            }
            this.decryptUsernamePassword(s_encryptedUserInfo);
        }
        catch (Exception ex) {
            m_logger.error(m_className, "ctor", ex);
        }
    }

    public String getServerName() {
        return this.m_sServerName;
    }

    public void setServerName(String serverName) {
        this.m_sServerName = serverName.trim();
    }

    public String getPort() {
        return this.m_sPort;
    }

    public void setPort(String port) {
        this.m_sPort = port.trim();
    }

    public String getUserName() {
        return this.m_sUserName;
    }

    public void setUserName(String userName) {
        this.m_sUserName = userName.trim();
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    public void setPassword(String password) {
        this.m_sPassword = password.trim();
    }

    public boolean getPublish() {
        return this.m_bPublish;
    }

    public void setPublish(boolean bPublish) {
        this.m_bPublish = bPublish;
    }

    public void saveToXML(Element parent) throws Exception {
        String m_method = "saveToXML";
        try {
            Element base = parent.getOwnerDocument().createElement("WSRRRegistry");
            if (this.m_sServerName != null) {
                base.setAttribute(XML_ATTRIBUTE_SERVER_NAME, this.m_sServerName);
            }
            if (this.m_sPort != null) {
                base.setAttribute(XML_ATTRIBUTE_PORT, this.m_sPort);
            }
            String encryptedString = this.encrypt(this.m_sUserName, this.m_sPassword);
            base.setAttribute(XML_ATTRIBUTE_USER_INFO, encryptedString);
            base.setAttribute(XML_ATTRIBUTE_PUBLISH, this.m_bPublish ? "1" : "0");
            parent.appendChild(base);
        }
        catch (Exception ex) {
            m_logger.error(m_className, m_method, ex);
            throw new VWException("vw.base.VWWSRRRegistry.ErrorSavingToXML", "WSRR: {0} - {1}", this.m_sServerName, ex.getLocalizedMessage());
        }
    }

    public String toString() {
        return this.m_sServerName;
    }

    public void releaseResources() {
        this.m_sServerName = null;
        this.m_sPort = null;
        this.m_sUserName = null;
        this.m_sPassword = null;
    }

    private void decryptUsernamePassword(String s_encryptedUserInfo) {
        String m_method = "decryptUsernamePassword";
        try {
            VWAuthItem item = this.decrypt(s_encryptedUserInfo);
            if (item != null) {
                this.m_sUserName = item.getName();
                this.m_sPassword = item.getPassword();
                if (this.m_sPassword != null && this.m_sPassword.compareTo("\"\"") == 0) {
                    this.m_sPassword = "";
                }
            } else {
                this.m_sUserName = "";
                this.m_sPassword = "";
            }
        }
        catch (Exception ex) {
            m_logger.error(m_className, m_method, ex);
        }
    }

    private String encrypt(String name, String password) throws VWException {
        String m_method = "encrypt";
        if (name != null && password != null && name.length() > 0) {
            try {
                String s_password = new String(password);
                return this.m_encryptUtils.encrypt(name, s_password);
            }
            catch (Throwable t) {
                m_logger.error(m_className, m_method + " for WSRR: " + this.m_sServerName, t);
                throw new VWException("vw.base.VWWSRRRegistry.EncryptionError", "Error encrypting password. {0}", t.getLocalizedMessage());
            }
        }
        throw new VWException("vw.base.VWWSRRRegistry.EncryptInvalidUserNamePassword", "User name or password is invalid.");
    }

    private VWAuthItem decrypt(String encryptedPassword) {
        String m_method = "decrypt";
        try {
            return this.m_encryptUtils.decrypt(encryptedPassword);
        }
        catch (Throwable t) {
            m_logger.error(m_className, m_method + " for WSRR: " + this.m_sServerName, t);
            return null;
        }
    }
}

